*************************************************************************
BY: Jim Sullivan

CHAGNE: 6/17/2004: imported new vehicle smoothing data: predveh_sm
which fixed the problem with no vehicle data for 2000:5.

CHAGNE: 12/12/2005: commented out "IF 6 LE fam_type LE 8" & 
"IF sex_ref=2" and ran it for all sm's, swnk's, and mm's 

CHANGE: 7/31/07 added some detailed exp. vars to final keep statement
and changed srv_year calculation to get 85:5 etc. correct

CHANGE: 8/3/07 added adjustments for cash contributions in 1985, home
furnishings (84-86) and parking (1984).

CHANGE: 8/3/07 RECODED ALL MISSING VFLOW TO ZERO B/C NO LONGER
USE THIS MEASURE, SO DON'T WANT IT TO CAUSE MISSING VALUES

CHANGE: 12/13/07: CHANGED FROM GZIP MACRO TO USING GZIP COMMEND.

CHANGE: 3/15/08: ADJUSTED TO BRING IN 2005 DATA.  REDID TOPCODE FOR RENTEQ
                 USING CPI-U-RS.
CHANGE: 3/18/08: ADDED CODE TO GENERATE DATA FOR STATA TO PREDICT RENTAL 
		 VALUES (USE TO BE CREATE4STATA.SAS), AND CODE TO GENERATE 
		 DATA FOR WINDOWS SAS TO PREDICT VEHICLE VALUES (USE TO BE
		 MKDATA4MATT.SAS
CHANGE: 8/2/08:  CHANGED DEFINITION OF TFLOW SO NOW IT EXCLUDES VEHICLE 
		 CHARGES.  ALSO EDITED SOME EXP. CATEGORIES FOR 84-86
		 (SEE FIX_FOOD*.SAS)
CHANGE: 8/18/09:  ADDED 2006 & 2007 DATA
CHANGE: 12/18/09:  ADDED 2008 DATA
CHANGE: 10/18/10:  ADDED 2009 DATA (NOTE, ALSO REMOVED TOPCODE ON RENTEQ)
CHANGE: 6/13/11:  ADDED fix_fstamps84 WHICH CREATES jfdstmpa for 1984

CHANGE: 10/21/11:  ADDED 2010 DATA

*************************************************************************
;

%INCLUDE "~/jim/gzipseq.mcr";

LIBNAME mydat '~/jim/data';
LIBNAME alldat '~/jim/data';

* WE BRING IN THE OLD PROCEDURE FOR VEHICHLES HERE ONLY FOR COMPARISON,
  THE NEW VEHICLE FLOWS WILL BE MERGED IN LATER;
X "gunzip ~/jim/data/predveh_all.sas7bdat.gz"; 
X "gunzip ~/jim/data/predveh_8081.sas7bdat.gz"; 
X "gunzip ~/jim/data/fix_retire.sas7bdat.gz"; 
X "gunzip ~/jim/data/fix_own_dwell.sas7bdat.gz"; 

*%gunzipsq(~/jim/data,famstep01_10,all,all);
*%gunzipsq(~/jim/data,famstep1,all,all);
*%gunzipsq(~/jim/data,famstep8081,all,all);
*%gunzipsq(~/jim/data,appl_all_80_10,all,all);
*%gunzipsq(~/jim/data,veh_fin_dat,all,all);
*%gunzipsq(~/jim/data,fix_fstamp84,all,all);

PROC SORT DATA=mydat.predveh_all;
   BY newid;
PROC SORT DATA=mydat.predveh_8081;
   BY newid;
PROC SORT DATA=alldat.famstep01_10;
   BY newid;
PROC SORT DATA=alldat.famstep1;
   BY newid;
PROC SORT DATA=alldat.famstep8081;
   BY newid;
PROC SORT DATA=alldat.appl_all_80_10;
   BY newid;
RUN;
PROC SORT DATA=mydat.fix_retire;
   BY newid;
RUN;
PROC SORT DATA=mydat.fix_own_dwell;
   BY newid;
RUN;
PROC SORT DATA=alldat.veh_fin_dat;
  BY newid; 
RUN; 
PROC SORT DATA=alldat.fix_fstamp84;
  BY newid; 
RUN; 

***********************************************************************
Get rental equivalent variables for 1993-1994      
***********************************************************************;

filename home93 pipe 'gunzip -c ~/jim/data/da6543.opi.y93.txt.gz';
filename home94 pipe 'gunzip -c ~/jim/data/da6710.opi.y94.txt.gz';
 
*************** 1993  *************************************************;
DATA hm93;  
INFILE home93 lrecl=300;
INPUT newid 4-11 code 22-24 renteq2 255-260;
IF code=100; 
*count=1; 
PROC SORT; 
     BY newid;    
PROC MEANS SUM NOPRINT; 
     BY newid;
     WHERE code=100;
     VAR renteq2;
     OUTPUT OUT=renteq93(DROP=_FREQ_ _TYPE_) SUM=;
PROC MEANS;
RUN;
 
*************** 1994  *************************************************;
DATA hm94;
INFILE home94 lrecl=300;
INPUT newid 4-11 code 22-24 renteq2 255-260; 
IF code=100;
*count=1;    
PROC SORT;   
     BY newid; 
PROC MEANS SUM NOPRINT; 
     BY newid;
     WHERE code=100;
     VAR renteq2; 
     OUTPUT OUT=renteq94(DROP=_FREQ_ _TYPE_) SUM=;
PROC MEANS;
RUN; 

DATA renteq9394;
MERGE renteq93 renteq94;
BY newid;
IF renteq2 NE .;

RUN;


* Convert character to numeric;
DATA alldat.famstep01_10;
SET alldat.famstep01_10(RENAME=(BLS_URBN = temp1 STATE = temp2 cutenure=temp3 EDUCA2= temp4
        MARITAL1 = temp12 RACE2 = temp13 REF_RACE = temp14  
        REGION= temp15 SMSASTAT = temp17 sex_ref=temp18 fam_type=temp19 intvmo=temp20));
BLS_URBN = temp1*1;
STATE = temp2*1;
cutenure = temp3*1;
EDUCA2 = temp4*1;
MARITAL1 = temp12*1;
RACE2 = temp13*1;
REF_RACE = temp14*1;
REGION = temp15*1;
SMSASTAT = temp17*1;
sex_ref=temp18*1; 
fam_type=temp19*1; 
intvmo=temp20*1;
drop temp1-temp4 temp12-temp15 temp17-temp20;
RUN;


*****************************************************************
Merge housing data car data with the master dataset
*****************************************************************;

DATA cons_exp80_10;
   MERGE alldat.famstep8081(RENAME=(totexppq=exp1 totexpcq=exp2)) 
	 alldat.famstep1 
	 alldat.famstep01_10;
   BY newid;
IF 801 LE qyear LE 911 THEN DO;
   win_ac=0;
   cen_ac=0;
   IF ac=1 AND ac_type=1 THEN cen_ac=1;
   IF ac=1 AND ac_type=2 THEN win_ac=1;
END;
IF qyear GT 911 THEN DO;
   IF win_ac GT 0 THEN win_ac=1;
   ELSE win_ac=0; 
   IF cen_ac GT 0 THEN cen_ac=1;
   ELSE cen_ac=0; 
END; 

***********************************************************************
ADJUST FOR CHANGE IN FOOD QUESTION.  FOOD AT HOME DIFFER FOR 1982-87
AND FOOD AWAY DIFFER AFTER 2007:1
FOR 2007:2 AND AFTER, WE ADJUST FOOD AWAY DOWN BY 0.55 BASED ON 
REGRESSION OF FDAWAY ON A NEW QUESTION INDICATOR, CONTROLLING FOR 
INTERVIEW MONTH AND RECALL LENGTH.  
SEE N:/~/Poverty Trends/adjust_food_away_post2007Q1.xls
AND EMAIL FROM TOM MURRAY, 8/20/09
***********************************************************************;
IF 831 LE qyear LE 874 THEN exp1=totexppq2;
   ELSE IF 881 LE qyear LE 1071 THEN exp1=totexppq;
   ELSE IF qyear GE 1072 THEN exp1=totexppq-0.55*fdawaypq;
IF 831 LE qyear LE 874 THEN exp2=totexpcq2;
   ELSE IF 881 LE qyear LE 1071 THEN exp2=totexpcq;
   ELSE IF qyear GE 1072 THEN exp2=totexpcq-0.55*fdawaycq;
RUN;
	
DATA alldat.cons_exp80_10; 
   MERGE cons_exp80_10(in=in1)
     mydat.predveh_all(KEEP= newid model1 newvtot cartot RENAME=(model1=model2))
     mydat.predveh_8081(KEEP= newid model1 newvtot cartot RENAME=(model1=model2))
     renteq9394(KEEP=newid renteq2)
     alldat.appl_all_80_10(KEEP=newid stove microw frig freezer disposal dishw
       washer dryer tv computer stereo vcr)
     mydat.fix_retire
     mydat.fix_own_dwell
     alldat.veh_fin_dat(KEEP= newid vehfin_tot)
     alldat.fix_fstamp84(KEEP= newid tot_fstamp2);
   BY newid; 
   IF in1;

******************************************
ADJUST FOR FACT THAT FREEZER=0 FOR ALL OBS
STARTING IN 2007:2
******************************************;
IF qyear GE 1072 THEN freezer=.;


******************************************
GENERATE SURVEY YEAR
******************************************;
srv_year=floor(qyear/10);
IF qyear IN (815,855,955,1045,1055,1105) THEN srv_year=srv_year+1;
******************************************
GENERATE REFERENCE YEAR
1=1980, 33=2011
******************************************;
DO i=1 TO 33; 
IF intvmo=1 AND srv_year=79+i THEN Ref_year=1979+i-1;
IF intvmo=2 AND srv_year=79+i THEN Ref_year=1979+i-1;
IF intvmo GT 2 AND srv_year=79+i THEN Ref_year=1979+i; 
IF intvmo GT 2 AND srv_year=79+i THEN Ref_year=1979+i; 
END; 
DROP i; 
 

*******************************************************************
Because different top-codes on renteq were used across years
I impose the most restictive top-code ($1000 in 1988) in all years.
The topcode is then assiged by adjust $1000 using the CPI-U-RS.
This is done in H:\Private\Poverty Trends\topcode.xls

For 2000 and after I used CPI All Items. 
Used CPI-U-RS for 72-86
NOTE: topcode value does not change between 85-85, 95-96, or 04-05
so don't need to worry about which topcode to apply to quarter 5 of
the first of these years
*******************************************************************;

IF srv_year=72 THEN renteq_topcode=392.08;
IF srv_year=73 THEN renteq_topcode=416.62;
IF srv_year=79 THEN renteq_topcode=636.36;
IF srv_year=80 THEN renteq_topcode=706.64;
IF srv_year=81 THEN renteq_topcode=773.01;
IF srv_year=82 THEN renteq_topcode=818.74;
IF srv_year=83 THEN renteq_topcode=852.76;
IF srv_year=84 THEN renteq_topcode=886.78;
IF srv_year=85 THEN renteq_topcode=916.34;
IF srv_year=86 THEN renteq_topcode=933.07;
IF srv_year=87 THEN renteq_topcode=964.86;
IF srv_year=88 THEN renteq_topcode=1000;
IF srv_year=89 THEN renteq_topcode=1042.94;
IF srv_year=90 THEN renteq_topcode=1094.81;
IF srv_year=91 THEN renteq_topcode=1134.41;
IF srv_year=92 THEN renteq_topcode=1162.86;
IF srv_year=93 THEN renteq_topcode=1191.86;
IF srv_year=94 THEN renteq_topcode=1216.95;
IF srv_year=95 THEN renteq_topcode=1246.51;
IF srv_year=96 THEN renteq_topcode=1279.98;
IF srv_year=97 THEN renteq_topcode=1307.31;
IF srv_year=98 THEN renteq_topcode=1325.71;
IF srv_year=99 THEN renteq_topcode=1353.6;
IF srv_year=100 THEN renteq_topcode=1398.77;
IF srv_year=101 THEN renteq_topcode=1437.81;
IF srv_year=102 THEN renteq_topcode=1460.68;
IF srv_year=103 THEN renteq_topcode=1494.14;
IF srv_year=104 THEN renteq_topcode=1534.3;
IF srv_year=105 THEN renteq_topcode=1585.61;
IF srv_year=106 THEN renteq_topcode=1637.6;
IF srv_year=107 THEN renteq_topcode=1684.05;
IF srv_year=108 THEN renteq_topcode=1748.76;
IF srv_year=109 THEN renteq_topcode=1742.13;
IF srv_year=110 THEN renteq_topcode=1770.88;
IF srv_year=111 THEN renteq_topcode=1784.72;

* NOTE, CURRENTLY NOT IMPOSING THE TOPCODE;
*IF renteq NE . THEN renteq=MIN(renteq,renteq_topcode);

IF cutenure GT 3 THEN hflow=0;
   ELSE IF qyear LT 933 OR qyear GT 944 THEN hflow=renteq*3;
   ELSE IF 933 LE qyear LE 944 THEN hflow=renteq2*3;
IF vehq=0 THEN vflow=0;
   ELSE vflow=model2*cartot;

*******************************************
CODE ALL MISSING VFLOW TO ZERO B/C NO LONGER
USE THIS MEASURE, SO DON'T WANT IT TO CAUSE
MISSING VALUES
*******************************************;
IF vflow=. THEN vflow=0;

***************************************************************************
CREATE VEHFIN*Q (VEHICLE FINANCING) FOR 80-93.  VEHICLE FINANCING IS NEEDED
TO SUBTRACT FROM TOTEXP TO GET TFLOW
***************************************************************************;
IF 801 LE qyear LE 934 THEN DO;
  IF vehfin_tot=. THEN vehfin_tot=0;
  vehfinpq=vehfin_tot/2;
  vehfincq=vehfin_tot/2;
END;

***************************************************************************
CREATE jfdstmpa for 1984.  
***************************************************************************;
IF 841 LE qyear LE 844 THEN jfdstmpa=tot_fstamp2;
IF 841 LE qyear LE 844 AND tot_fstamp2=. THEN jfdstmpa=0;



****************************************************
Generate consumption/expenditure categories
****************************************************;

tflow=SUM(OF exp1 exp2)
      -SUM(OF educapq educacq 
	      healthpq healthcq 
	      retpenpq retpencq 
	      cashcopq cashcocq 
	      vehicpq vehiccq
	      cartknpq cartkncq cartkupq cartkucq caropq carocq 
	      owndwepq owndwecq
	      vehfinpq vehfincq)
      +hflow+vflow;

***************************************************************************
ADJUST TFLOW IN 84-86 FOR MISCLASSIFIED UCC'S
--hfurn should not have been subtracted as part of ownde*q, so add it back
--parking should have been subtracted as part of ownde*q, so sub it out
***************************************************************************;
IF 841 LE qyear LE 864 THEN DO;
   IF hfurn_adj=. THEN hfurn_adj=0;
   tflow=tflow+hfurn_adj;
END;
IF 841 LE qyear LE 844 THEN DO;
   IF park_adj=. THEN park_adj=0;
   tflow=tflow-park_adj;
END;

flowless=SUM(OF educapq educacq healthpq healthcq retpenpq 
              retpencq cashcopq cashcocq vehicpq vehiccq 
              cartknpq cartkncq cartkupq cartkucq caropq 
              carocq owndwepq owndwecq vehfinpq vehfincq);


** create state=99 for missings and recodes;
IF state=. THEN state1=99;
   ELSE IF st_flag='R' THEN state1=99; 
   ELSE state1=state; 
 
totexp=exp1+exp2; 

**********************************************************************
CORRECT TOTEXP FOR INCORRECT RETIREMENT, PENSION, AND CASH CONTRIBS IN 1985, 
NOTE: TFLOW IS OK BECAUSE SUBTRACT OUT THE WRONG MEASURE
**********************************************************************;
IF 851 LE qyear LE 855 AND tot_retpen=. THEN tot_retpen=0;
IF 851 LE qyear LE 855 AND tot_cashco=. THEN tot_cashco=0;
IF 851 LE qyear LE 855 THEN totexp=totexp
		-SUM(OF retpenpq retpencq)
		-SUM(OF cashcopq cashcocq)+tot_retpen+tot_cashco/4;

IF 851 LE qyear LE 855 THEN totexp2=totexp-tot_cashco/4-SUM(OF miscpq misccq); 
   ELSE totexp2=totexp-SUM(OF miscpq misccq cashcopq cashcocq); 

*****************************************************************
Create poverty thresholds through 99:1, add through 2002 because
some obs for pov_cut are set to zero for 01:1-02:1
*****************************************************************;


**************************************************************************
NOTE NOTE: THESE THRESHOLDS ARE NOT COMPLETE, DON'T VARY BY COMPOSITION
**************************************************************************;
if ref_year=1980 then do;
if Fam_size=1 and age_ref < 65 then Povline= 4284       ;
else if Fam_size=1 and age_ref ge 65 then Povline=3950    ;
else if Fam_size = 2 and age_ref < 65 then Povline=5676      ;
else if Fam_size=2 and age_ref ge 65 then Povline=  5655    ; 
else if Fam_size=3 then Povline=6635      ;
else if Fam_size=4 then Povline=8380      ;
else if Fam_size=5 then Povline=9677      ;
else if Fam_size=6 then Povline=10798     ;
else if Fam_size=7 then Povline=11840     ;
else if Fam_size=8 then Povline=13435    ;
else if Fam_size ge 9 then Povline=15921;
end;

if ref_year=1981 then do;
if Fam_size=1 and age_ref < 65 then Povline= 4729      ;
else if Fam_size=1 and age_ref ge 65 then Povline=4359   ;
else if Fam_size = 2 and age_ref < 65 then Povline=6265     ;
else if Fam_size=2 and age_ref ge 65 then Povline= 6241   ; 
else if Fam_size=3 then Povline=7323     ;
else if Fam_size=4 then Povline=9250     ;
else if Fam_size=5 then Povline=10681     ;
else if Fam_size=6 then Povline=11918    ;
else if Fam_size=7 then Povline=13068    ;
else if Fam_size=8 then Povline=14829   ;
else if Fam_size ge 9 then Povline=17572;
end;

if ref_year=1982 then do;
if Fam_size=1 and age_ref < 65 then Povline= 5019     ;
else if Fam_size=1 and age_ref ge 65 then Povline=4626  ;
else if Fam_size = 2 and age_ref < 65 then Povline=6649    ;
else if Fam_size=2 and age_ref ge 65 then Povline= 6624  ; 
else if Fam_size=3 then Povline=7772    ;
else if Fam_size=4 then Povline=9817    ;
else if Fam_size=5 then Povline=11336    ;
else if Fam_size=6 then Povline=12649   ;
else if Fam_size=7 then Povline=13869   ;
else if Fam_size=8 then Povline=15738  ;
else if Fam_size ge 9 then Povline=18649;
end;


if ref_year=1983 then do;
if Fam_size=1 and age_ref < 65 then Povline= 5180    ;
else if Fam_size=1 and age_ref ge 65 then Povline=4775 ;
else if Fam_size = 2 and age_ref < 65 then Povline=6863   ;
else if Fam_size=2 and age_ref ge 65 then Povline= 6837 ; 
else if Fam_size=3 then Povline=8022   ;
else if Fam_size=4 then Povline=10133   ;
else if Fam_size=5 then Povline=11701   ;
else if Fam_size=6 then Povline=13056  ;
else if Fam_size=7 then Povline=14315  ;
else if Fam_size=8 then Povline=16244  ;
else if Fam_size ge 9 then Povline=19249;
end;


if ref_year=1984 then do;
if Fam_size=1 and age_ref < 65 then Povline= 5400  ;
else if Fam_size=1 and age_ref ge 65 then Povline=4979;
else if Fam_size = 2 and age_ref < 65 then Povline=7155  ;
else if Fam_size=2 and age_ref ge 65 then Povline= 7128; 
else if Fam_size=3 then Povline=8363  ;
else if Fam_size=4 then Povline=10564  ;
else if Fam_size=5 then Povline=12199  ;
else if Fam_size=6 then Povline=13611 ;
else if Fam_size=7 then Povline=14925 ;
else if Fam_size=8 then Povline=16935 ;
else if Fam_size ge 9 then Povline=20069;
end;


if ref_year=1985 then do;
if Fam_size=1 and age_ref < 65 then Povline= 5593   ;
else if Fam_size=1 and age_ref ge 65 then Povline=5156 ;
else if Fam_size = 2 and age_ref < 65 then Povline=7410   ;
else if Fam_size=2 and age_ref ge 65 then Povline= 7382 ; 
else if Fam_size=3 then Povline=8662 ;
else if Fam_size=4 then Povline=10941   ;
else if Fam_size=5 then Povline=12634   ;
else if Fam_size=6 then Povline=14097  ;
else if Fam_size=7 then Povline=15457  ;
else if Fam_size=8 then Povline=17540  ;
else if Fam_size ge 9 then Povline=20785;
end;

if ref_year=1986 then do;
if Fam_size=1 and age_ref < 65 then Povline= 5701    ;
else if Fam_size=1 and age_ref ge 65 then Povline=5255  ;
else if Fam_size = 2 and age_ref < 65 then Povline=7553    ;
else if Fam_size=2 and age_ref ge 65 then Povline= 7524  ; 
else if Fam_size=3 then Povline=8829  ;
else if Fam_size=4 then Povline=11151    ;
else if Fam_size=5 then Povline=12877    ;
else if Fam_size=6 then Povline=14368   ;
else if Fam_size=7 then Povline=15755   ;
else if Fam_size=8 then Povline=17877   ;
else if Fam_size ge 9 then Povline=21185;
end;

if ref_year=1987 then do;
if Fam_size=1 and age_ref < 65 then Povline= 5909     ;
else if Fam_size=1 and age_ref ge 65 then Povline=5447  ;
else if Fam_size = 2 and age_ref < 65 then Povline=7829     ;
else if Fam_size=2 and age_ref ge 65 then Povline= 7799   ; 
else if Fam_size=3 then Povline=9151   ;
else if Fam_size=4 then Povline=11559     ;
else if Fam_size=5 then Povline=13348     ;
else if Fam_size=6 then Povline=14893   ;
else if Fam_size=7 then Povline=16330    ;
else if Fam_size=8 then Povline=18530    ;
else if Fam_size ge 9 then Povline=21959;
end;

if ref_year=1988 then do;
if Fam_size=1 and age_ref < 65 then Povline= 6155      ;
else if Fam_size=1 and age_ref ge 65 then Povline=5674   ;
else if Fam_size = 2 and age_ref < 65 then Povline=8154      ;
else if Fam_size=2 and age_ref ge 65 then Povline= 8123    ; 
else if Fam_size=3 then Povline=9531    ;
else if Fam_size=4 then Povline=12039      ;
else if Fam_size=5 then Povline=13902      ;
else if Fam_size=6 then Povline=15511    ;
else if Fam_size=7 then Povline=17008     ;
else if Fam_size=8 then Povline=19300     ;
else if Fam_size ge 9 then Povline=22871;
end;

if ref_year=1989 then do;
if Fam_size=1 and age_ref < 65 then Povline= 6451       ;
else if Fam_size=1 and age_ref ge 65 then Povline=5947    ;
else if Fam_size = 2 and age_ref < 65  then Povline=8547       ;
else if Fam_size=2 and age_ref ge 65 then Povline= 8515     ; 
else if Fam_size=3 then Povline=9990     ;
else if Fam_size=4 then Povline=12619       ;
else if Fam_size=5 then Povline=14572       ;
else if Fam_size=6 then Povline=16259     ;
else if Fam_size=7 then Povline=17828      ;
else if Fam_size=8 then Povline=20230      ;
else if Fam_size ge 9 then Povline=23973;
end;

if ref_year=1990 then do;
if Fam_size=1 and age_ref < 65 then Povline= 6800 ;
else if Fam_size=1 and age_ref ge 65 then Povline=6268     ;
else if Fam_size = 2 and age_ref < 65 then Povline=9009 ;
else if Fam_size=2 and age_ref ge 65 then Povline= 8975      ; 
else if Fam_size=3 then Povline=10530 ;
else if Fam_size=4 then Povline=13301 ;
else if Fam_size=5 then Povline=15359 ;
else if Fam_size=6 then Povline=17137 ;
else if Fam_size=7 then Povline=18791 ;
else if Fam_size=8 then Povline=21323 ;
else if Fam_size ge 9 then Povline=25268;
end;

if ref_year=1991 then do;
if Fam_size=1 and age_ref < 65 then Povline= 7086;
else if Fam_size=1 and age_ref ge 65 then Povline=6532      ;
else if Fam_size = 2 and age_ref < 65 then Povline=9388  ;
else if Fam_size=2 and age_ref ge 65 then Povline= 9352       ; 
else if Fam_size=3 then Povline=10973  ;
else if Fam_size=4 then Povline=13860  ;
else if Fam_size=5 then Povline=16006  ;
else if Fam_size=6 then Povline=17859  ;
else if Fam_size=7 then Povline=19582  ;
else if Fam_size=8 then Povline=22220  ;
else if Fam_size ge 9 then Povline=26331;
end;


if ref_year=1992 then do;
if Fam_size=1 and age_ref < 65 then Povline= 7299 ;
else if Fam_size=1 and age_ref ge 65 then Povline=6729       ;
else if Fam_size = 2 and age_ref < 65 then Povline=9670   ;
else if Fam_size=2 and age_ref ge 65 then Povline= 9634        ; 
else if Fam_size=3 then Povline=11304   ;
else if Fam_size=4 then Povline=14277   ;
else if Fam_size=5 then Povline=16487   ;
else if Fam_size=6 then Povline=18396  ;
else if Fam_size=7 then Povline=20171  ;
else if Fam_size=8 then Povline=22889   ;
else if Fam_size ge 9 then Povline=27124;
end;


if ref_year=1993 then do;
if Fam_size=1 and age_ref < 65 then Povline= 7518;
else if Fam_size=1 and age_ref ge 65 then Povline=6930        ;
else if Fam_size = 2 and age_ref < 65 then Povline=9960;
else if Fam_size=2 and age_ref ge 65 then Povline= 9922         ; 

else if Fam_size=3 then Povline=11642;
else if Fam_size=4 then Povline=14705;
else if Fam_size=5 then Povline=16981;
else if Fam_size=6 then Povline=18947;
else if Fam_size=7 then Povline=20775;
else if Fam_size=8 then Povline=23574;
else if Fam_size ge 9 then Povline=27936;
end;

if ref_year=1994 then do;
if Fam_size = 1 and age_ref < 65 then Povline=7710;
else if Fam_size=1 and age_ref ge 65 then Povline=7108         ;
else if Fam_size = 2 and age_ref < 65 then Povline=10215;
else if Fam_size=2 and age_ref ge 65 then Povline= 10176          ; 
else if Fam_size=3 then Povline=11940;
else if Fam_size=4 then Povline=15081;
else if Fam_size=5 then Povline=17416;
else if Fam_size=6 then Povline=19432;
else if Fam_size=7 then Povline=21307;
else if Fam_size=8 then Povline=24178;
else if Fam_size ge 9 then Povline=28651;
end;

if ref_year=1995 then do;
if Fam_size = 1 and age_ref < 65 then Povline=7929;
else if Fam_size=1 and age_ref ge 65 then Povline=7309;
else if Fam_size = 2 and age_ref < 65 then Povline=10504;
else if Fam_size=2 and age_ref ge 65 then Povline= 10465 ; 
else if Fam_size=3 then Povline=12278;
else if Fam_size=4 then Povline=15509;
else if Fam_size=5 then Povline=17909;
else if Fam_size=6 then Povline=19983;
else if Fam_size=7 then Povline=21911;
else if Fam_size=8 then Povline=24863;
else if Fam_size ge 9 then Povline=29463;
end;

if ref_year=1996 then do;
if Fam_size = 1 and age_ref < 65 then Povline=8163;
else if Fam_size=1 and age_ref ge 65 then Povline=7525 ;
else if Fam_size = 2 and age_ref < 65 then Povline=10815 ;
else if Fam_size=2 and age_ref ge 65 then Povline= 10774  ; 
else if Fam_size=3 then Povline=12641 ;
else if Fam_size=4 then Povline=15967 ;
else if Fam_size=5 then Povline=18438 ;
else if Fam_size=6 then Povline=20573 ;
else if Fam_size=7 then Povline=22558 ;
else if Fam_size=8 then Povline=25597 ;
else if Fam_size ge 9 then Povline=30333;
end;


if ref_year=1997 then do;
if Fam_size = 1 and age_ref < 65 then Povline=8350;
else if Fam_size=1 and age_ref ge 65 then Povline=7698  ;
else if Fam_size = 2 and age_ref < 65 then Povline=11063;
else if Fam_size=2 and age_ref ge 65 then Povline= 11021   ; 
else if Fam_size=3 then Povline=12931;
else if Fam_size=4 then Povline=16333;
else if Fam_size=5 then Povline=18861;
else if Fam_size=6 then Povline=21045;
else if Fam_size=7 then Povline=23076;
else if Fam_size=8 then Povline=26185;
else if Fam_size ge 9 then Povline=31029;
end;

if ref_year=1998 then do;
if Fam_size = 1  and age_ref < 65 then Povline=8480;
else if Fam_size=1 and age_ref ge 65 then Povline=7818   ;
else  if Fam_size = 2 and age_ref < 65 then Povline=11235;
else if Fam_size=2 and age_ref ge 65 then Povline= 11193    ; 
else if Fam_size=3 then Povline=13133;
else if Fam_size=4 then Povline=16588;
else if Fam_size=5 then Povline=19155;
else if Fam_size=6 then Povline=21373;
else if Fam_size=7 then Povline=23435;
else if Fam_size=8 then Povline=26593;
else if Fam_size ge 9 then Povline=31513;
end;

if ref_year=1999 then do;
if Fam_size = 1  and age_ref < 65 then Povline=8667;
else if Fam_size=1 and age_ref ge 65 then Povline=7990   ;
else  if Fam_size = 2 and age_ref < 65 then Povline=11483;
else if Fam_size=2 and age_ref ge 65 then Povline= 11440    ; 
else if Fam_size=3 then Povline=13423;
else if Fam_size=4 then Povline=16954;
else if Fam_size=5 then Povline=19578;
else if Fam_size=6 then Povline=21845;
else if Fam_size=7 then Povline=23953;
else if Fam_size=8 then Povline=27180;
else if Fam_size ge 9 then Povline=32208;
end;

if ref_year=2000 then do;
if Fam_size = 1  and age_ref < 65 then Povline=8959;
else if Fam_size=1 and age_ref ge 65 then Povline=8259   ;
else  if Fam_size = 2 and age_ref < 65 then Povline=11869;
else if Fam_size=2 and age_ref ge 65 then Povline= 11824    ; 
else if Fam_size=3 then Povline=13874;
else if Fam_size=4 then Povline=17524;
else if Fam_size=5 then Povline=20236;
else if Fam_size=6 then Povline=22579;
else if Fam_size=7 then Povline=24758;
else if Fam_size=8 then Povline=28093;
else if Fam_size ge 9 then Povline=33291;
end;

if ref_year=2001 then do;
if Fam_size = 1  and age_ref < 65 then Povline=9214;
else if Fam_size=1 and age_ref ge 65 then Povline=8494   ;
else  if Fam_size = 2 and age_ref < 65 then Povline=12207;
else if Fam_size=2 and age_ref ge 65 then Povline= 12161    ; 
else if Fam_size=3 then Povline=14269;
else if Fam_size=4 then Povline=18022;
else if Fam_size=5 then Povline=20812;
else if Fam_size=6 then Povline=23221;
else if Fam_size=7 then Povline=25462;
else if Fam_size=8 then Povline=28893;
else if Fam_size ge 9 then Povline=34238;
end;

if ref_year=2002 then do;
if Fam_size = 1  and age_ref < 65 then Povline=9359;
else if Fam_size=1 and age_ref ge 65 then Povline=8628   ;
else  if Fam_size = 2 and age_ref < 65 then Povline=12400;
else if Fam_size=2 and age_ref ge 65 then Povline= 12353    ; 
else if Fam_size=3 then Povline=14494;
else if Fam_size=4 then Povline=18307;
else if Fam_size=5 then Povline=21141;
else if Fam_size=6 then Povline=23588;
else if Fam_size=7 then Povline=25865;
else if Fam_size=8 then Povline=29350;
else if Fam_size ge 9 then Povline=34780;
end;


**********************************************************
Create a catch all category of work-expenses. This will
include a lot of non-work expenses, but is one that 
can be defined consistently accross all years
NOTE: Subtract vehicle payments here, because they're 
already subtracted out above (tflow*)
**********************************************************;
workexp1=SUM(OF transpq housoppq apparpq transcq housopcq apparcq)
          -SUM(OF vehicpq cartkupq cartknpq caropq vehiccq cartkucq cartkncq carocq);
workexp2=SUM(OF housoppq housopcq);


IF qyear LE 991 THEN pov_cut=povline;
   ELSE IF qyear GT 991 AND pov_cut LT 1000 THEN pov_cut=povline;

* codebook is wrong for 2003. origin2 (horref) is 1=hisp, 2=not hisp for 2003 only;
IF qyear LE 1031 AND origin1=2 THEN hispanic=1;
   ELSE IF qyear LE 1031 AND origin1 IN(1,3,4) THEN hispanic=0;
   ELSE IF 1032 LE qyear LE 1034 AND origin2=1 THEN hispanic=1;
   ELSE IF qyear GE 1041 AND 1 LE origin2 LE 8 THEN hispanic=1;
   ELSE IF qyear GE 1032 THEN hispanic=0;
  
* TV, computer, stereo, and VCR are not available 80-87, but they are 
  coded as zero instead of missing for 84-87;
IF 801 LE qyear LE 875 THEN DO;
   tv=.; 
   computer=.;
   stereo=.; 
   vcr=.;
END;

IF building=1 THEN htype=1;			/* single fam home */
  ELSE IF building IN(2 3) THEN htype=2;	/* townhome */
  ELSE IF building IN(4 5 6 7 8) THEN htype=3;	/* apt,etc */
  ELSE IF building IN(9) THEN htype=4;		/* mobile home or trailer */
  ELSE IF building IN(10) THEN htype=5;		/* college dorm */
  ELSE IF building IN(11) THEN htype=6;		/* other */
*A SMALL % OF OBS IN 2003:2-2004:1 AND IN SOME YRS IN 90S HAVE MISSING BUILDING, SO ADD TO OTHER CATEGORY;
  ELSE IF building=. THEN htype=6;


KEEP newid exp1 exp2 hflow vflow tflow qyear model2 cartot newvtot
   vehq foodpq foodcq foodpq2 foodcq2 utilpq utilcq telephpq telephcq
   intvmo intvyr region age_ref age2 bls_urbn smsastat fam_size 
   as_comp1 as_comp2 as_comp3 as_comp4 as_comp5 perslt18 persot64 fam_type marital1 ref_race 
   sex_ref finlwt educ_ref educa2 cutenure rooms publhous govtcost
   stove microw frig freezer disposal dishw win_ac cen_ac
       washer dryer tv computer stereo vcr  bedroom bathrm hlfbath st_flag state 
	renteq renteq2 rendwepq rendwecq srv_year ref_year state1 totexp totexp2 pov_cut workexp1 workexp2
   fdhomepq fdhomecq fdawaypq fdawaycq fincatax fincbtax fica childage respstat 
   jfdstmpa foodsmpx foodspbx foodsmpm origin1 origin2 hispanic incnonw1 incweek1 incweek2 welfarex
	rent2 owndwepq owndwecq vehicpq vehiccq cartknpq cartkncq cartkupq cartkucq
                     caropq carocq healthpq healthcq transpq apparpq transcq apparcq nonincmx
	earnincx frretirx unemplx intearnx finincx pensionx 
	unemplbx internbx finincbx pnsionbx entertpq entertcq houspq houscq bbydaypq bbydaycq inc_hrs1
	flowless erankmth tot_retpen tot_cashco educapq educacq cashcopq cashcocq retpenpq retpencq miscpq misccq
	alcbevpq alcbevcq gasmopq gasmocq vehfinpq vehfincq tobaccpq tobacccq othaplpq othaplcq no_earnr
	ckbkactx secestx usbndx savacctx
	ckbkactx_ secestx_ usbndx_ savacctx_
        compbndx compckgx compsavx compsecx
        comp_ndx comp_kgx comp_avx comp_ecx
	houseqpq houseqcq perinspq perinscq lifinspq lifinscq perscapq perscacq readpq readcq building htype vehinspq vehinscq
	fsalaryx earncomp fnonfrmx ffrmincx fssix othrincx
	vothrlop vothrloc utilownp utilownc utilrntp utilrntc emrtpnop emrtpnoc fdmappq fdmapcq rntapycq rntapypq
	wtrep01-wtrep44;

PROC SORT;
   BY qyear;

PROC MEANS;
PROC MEANS;
   BY qyear;
RUN;

*************************************************************************
GENERATE DATA TO BRING INTO STATA TO PREDICT A RENTAL VALUE FOR THOSE IN
GOV'T OR SUBS HOUSING.  THIS USE TO BE DONE IN CREATE4STATA.SAS, BUT NOW
I HAVE BROUGHT THAT PROGRAM HERE.
*************************************************************************; 
filename outfile1 '~/jim/poverty/output/statadat.dat';
    
data statadat; 
set alldat.cons_exp80_10;
if cutenure=4 OR publhous=1 OR govtcost=1;
IF publhous=1 OR govtcost=1 THEN fullrent=0;
ELSE fullrent=1;
mo_rent=(rendwepq+rendwecq)/3;
        
KEEP newid ref_year state1 fullrent mo_rent totexp region age_ref bls_urbn fam_size fam_type
        marital1 ref_race sex_ref educ_ref  
        rooms publhous govtcost stove microw frig freezer disposal dishw
        win_ac cen_ac washer dryer bedroom bathrm hlfbath smsastat; 
RUN; 
PROC MEANS;
RUN; 

DATA _null_; 
   SET statadat;
   FILE outfile1 lrecl=1200 pad;
   PUT newid ref_year state1 totexp region age_ref bls_urbn fam_size fam_type 
        marital1 ref_race sex_ref educ_ref fullrent mo_rent
        rooms publhous govtcost stove microw frig freezer disposal dishw
        win_ac cen_ac washer dryer bedroom bathrm hlfbath smsastat; 
RUN;

*************************************************************************
GENERATE DATA TO BRING INTO WINDOWS SAS TO PREDICT VEHICLE VALUES.
THIS USE TO BE DONE IN MKDATA4MATT.SAS, BUT NOW I HAVE BROUGHT THAT PROGRAM 
HERE.
*************************************************************************; 

DATA mydat.demog8010; 
   SET alldat.cons_exp80_10; 
 
health=SUM(OF healthpq healthcq); 
 
*totexp is corrected for food;
expend=totexp-SUM(OF vehicpq vehiccq cartknpq cartkncq cartkupq cartkucq
                     caropq carocq health);
 
*******************************************************************
CREATE MUTUALLY EXCLUSIVE DEMOGRAPHIC GROUPS, & DUMMIES
THIS IS DONE AGAIN IN POVERTY_TREND_HEALTH.SAS 
*******************************************************************;
IF age_ref LE 64 AND perslt18 GT 0 AND marital1 GT 1 THEN ftype=1;
   ELSE IF age_ref LE 64 AND perslt18 GT 0 AND marital1=1 THEN ftype=2;
   ELSE IF age_ref LE 64 AND perslt18=0 AND marital1 GT 1 THEN ftype=3;
   ELSE IF age_ref LE 64 AND perslt18=0 AND marital1=1 THEN ftype=4;
   ELSE IF age_ref GE 65 THEN ftype=5; 
ARRAY fam(1:5); 
   DO t=1 TO 5; 
     IF ftype=t THEN fam(t)=1; 
       ELSE fam(t)=0; 
   END; 

ARRAY regn(1:4); 
   DO t=1 to 4; 
        IF region=t THEN regn(t)=1;
        ELSE IF region NE . THEN regn(t)=0;
END; 
IF 801 LE qyear LE 955 THEN DO; 
        IF educ_ref=1 or educ_ref=2 or educ_ref=7 then ed1=1;
                ELSE ed1=0;
        IF educ_ref=3 then ed2=1;
                ELSE ed2=0;
        IF educ_ref=4 then ed3=1; 
                ELSE ed3=0;
        IF educ_ref=5 or educ_ref=6 then ed4=1; 
                ELSE ed4=0;
END; 
IF qyear GT 955 THEN DO;
        IF educ_ref=0 or educ_ref=10 or educ_ref=11 then ed1=1;
                ELSE ed1=0; 
        IF educ_ref=12 then ed2=1; 
                ELSE ed2=0;
        IF 13 LE educ_ref LE 14 then ed3=1;
                ELSE ed3=0; 
        IF 15 LE educ_ref LE 17 THEN ed4=1; 
                ELSE ed4=0;
END; 
KEEP qyear newid expend age_ref fam1-fam5 
        fam_size ed1-ed4 regn1-regn4 vehq;
RUN; 
 
PROC SORT DATA=mydat.demog8010; 
   BY qyear; 
RUN; 
                 
PROC MEANS DATA=mydat.demog8010; 
RUN; 
PROC MEANS DATA=mydat.demog8010; 
   BY qyear; 
RUN; 


*%gzipsq(work,cons_exp80_10,~/jim/data); 

X "gzip -f ~/jim/data/predveh_all.sas7bdat"; 
X "gzip -f ~/jim/data/predveh_8081.sas7bdat"; 
X "gzip -f ~/jim/data/fix_retire.sas7bdat"; 
X "gzip -f ~/jim/data/fix_own_dwell.sas7bdat"; 

